procedure $see_profiles
argument local string scalar runno
argument local namelist freqs
argument local string scalar db_path = ""
argument local aveonly = false
block

   if missing(location(@open.db,"LOUT"))
      open <ac re> file(local'db_path+"lfpr_run"+runno+".db") as lout
      -local'loutopened = TRUE
   else
      -local'loutopened = FALSE
   end if

   device graphics postp
   page margins horizontal 0, vertical 0

   glue null
   overwrite on

   thickness medium 3
   thickness thick 10

   legend contents description off 
   legend size small

   map color postscript C6  "Lemonchiffon", C7  "505C5C", c9  "F30E0E", C10 "lavender", &&
                        C11 "B50E4F",C12 "970E70", C13 "780E90", C14 "silver", C15 "3B0ED2", &&
                        C16 "1D0EF3"

   scatter color #1 C1, #2 C9, #3 C12, #4 C16, #5 C1, &&
                 #6 C1, #7 C9, #8 C12, #9 C16
   scatter style #1 solid, #2 solid, #3 solid, #4 solid, #5 solid, &&
                 #6 dashed, #7 dashed, #8 dashed, #9 dashed
   symbolsize ssquare 12, square 12, scircle 12

   plot color #1 c1, #2 c9, #3 c11, #4 c13, #5 c15, #6 c16, #7 c1, &&
              #8 c1, #9 c9,#10 c11,#11 c13,#12 c15,#13 c16,#14 c1
   plot style #1 solid, #2 solid, #3 solid, #4 solid, #5 solid, #6 solid, #7 solid, &&
              #8 dashed,#9 dashed,#10 dashed,#11 dashed,#12 dashed,#13 dashed,#14 dashed


   page divi rows 2, columns 1
   if (exists(lout'runtime))
      page title area length standard
      page title #1 right text datefmt(lout'runtime), font f10, size xsmall
   end if

   legend size xsmall, fill horizontal, font F10
   legend division row auto, column 2
   tick label size xsmall, font F10

   loop for sfreq in freqs

      open <ac over; kind graphic> file("run"+local'runno+"profiles_"+name(sfreq)+".ps") as prof.ps
      channel graphics prof.ps
      channel reports prof.ps

      -local'teff = exists(lout'tem&sfreq)

      -local'strfreq = (if name(sfreq) eq "M" then "Monthly" else "Quarterly")
      cell(1,1)
      graph 
         title #1 size med, text "Age Effects (Male)"
         title #2 size small, text local'strfreq 
         tick bottom numeric linear (16 to 79 step 2)
         if aveonly
            data lout'aeavgm&sfreq <scatter name "@ Average "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&   
                 lout'aem&sfreq <scatter name "Raw Age Effects", draw line, thickness thick, axis right> &&
              vs lout'ages&sfreq
         else
            tick left numeric linear (0 to 1 step 0.2)
            data lout'aeavgm&sfreq <scatter name "@ Average "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&   
                 lout'aeminm&sfreq <scatter name "@ Minimum "+(if teff then "Time & " else  "")+"Cohort Effect", draw line>, &&
                 lout'aemedm&sfreq <scatter name "@ Median "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&   
                 lout'aemaxm&sfreq <scatter name "@ Maximum "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&   
                 lout'aem&sfreq <scatter name "Raw Age Effects", draw line, thickness thick, axis right> &&
              vs lout'ages&sfreq
         end if
      end graph

      cell(2,1)
      graph 
         title #1 size med, text "Age Effects (Female)"
         title #2 size small, text local'strfreq
         tick bottom numeric linear (16 to 79 step 2)
         if aveonly
            data lout'aeavgf&sfreq <scatter name "@ Average "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&
                 lout'aef&sfreq <scatter name "Raw Age Effects", draw line, thickness thick, axis right> &&
              vs lout'ages&sfreq
         else
            tick left numeric linear (0 to 1 step 0.2)
            data lout'aeavgf&sfreq <scatter name "@ Average "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&
                 lout'aeminf&sfreq <scatter name "@ Minimum "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&
                 lout'aemedf&sfreq <scatter name "@ Median "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&
                 lout'aemaxf&sfreq <scatter name "@ Maximum "+(if teff then "Time & " else "")+"Cohort Effect", draw line>, &&
                 lout'aef&sfreq <scatter name "Raw Age Effects", draw line, thickness thick, axis right> &&
              vs lout'ages&sfreq
         end if
      end graph

      if local'teff
         cell(1,1)
         graph 
            title #1 size med, text "Time Effects (Male)"
            title #2 size small, text local'strfreq 

            if aveonly
               data lout'teavgm&sfreq <plot name "@ Average Age & Cohort Effect", draw line>, &&   
                    lout'tem&sfreq <plot name "Raw Age Effects", draw line, thickness thick, axis right>
            else
               tick left numeric linear (0 to 1 step 0.2)
               data lout'teavgm&sfreq <plot name "@ Average Age & Cohort Effect", draw line>, &&   
                    lout'teminm&sfreq <plot name "@ Minimum Age & Cohort Effect", draw line>, &&
                    lout'temedm&sfreq <plot name "@ Median Age & Cohort Effect", draw line>, &&   
                    lout'temaxm&sfreq <plot name "@ Maximum Age & Cohort Effect", draw line>, &&   
                    lout'tem&sfreq <plot name "Raw Age Effects", draw line, thickness thick, axis right>
            end if
         end graph

         cell(2,1)
         graph 
            title #1 size med, text "Time Effects (Female)"
            title #2 size small, text local'strfreq
            if aveonly
               data lout'teavgf&sfreq <plot name "@ Average Age & Cohort Effect", draw line>, &&
                    lout'tef&sfreq <plot name "Raw Age Effects", draw line, thickness thick, axis right>
            else
               tick left numeric linear (0 to 1 step 0.2)
               data lout'teavgf&sfreq <plot name "@ Average Age & Cohort Effect", draw line>, &&
                    lout'teminf&sfreq <plot name "@ Minimum Age & Cohort Effect", draw line>, &&
                    lout'temedf&sfreq <plot name "@ Median Age & Cohort Effect", draw line>, &&
                    lout'temaxf&sfreq <plot name "@ Maximum Age &Cohort Effect", draw line>, &&
                    lout'tef&sfreq <plot name "Raw Age Effects", draw line, thickness thick, axis right>
            end if
         end graph
      end if

      cell(1,1)
      graph 
         date * to 1998
         order 4; order region 1,lines 2, markings 3, series 5
         title #1 size med, text "Cohort Effects (Male)"
         title #2 size small, text local'strfreq

         if aveonly
            data lout'ceavgm&sfreq <plot name "@ Average "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'cem&sfreq <plot name "Raw Cohort Effects", draw line, thickness thick, axis right>
         else
            tick left numeric linear (0 to 1 step 0.2)
            data lout'ceavgm&sfreq <plot name "@ Average "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'ceminm&sfreq <plot name "@ Minimum "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'ce25m&sfreq  <plot name "@ 25th Pct Age Effect", draw line>, &&
                 lout'cemedm&sfreq <plot name "@ Median "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'ce75m&sfreq  <plot name "@ 75th Pct Age Effect", draw line>, &&
                 lout'cemaxm&sfreq <plot name "@ Maximum "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'cem&sfreq <plot name "Raw Cohort Effects", draw line, thickness thick, axis right>
         end if

         draw line <depict axis bottom, color c14, placement end; glue dot> &&
                   (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg,@left.axis.min) to &&
                   (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg,@left.axis.max)
         draw line <depict axis bottom, color c14, placement end; glue dot> &&
                   (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg-lout'reg_cohort_num,@left.axis.min) to &&
                   (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg-lout'reg_cohort_num,@left.axis.max)
         draw line <depict axis bottom, color c14, placement beginning; glue dot> &&
                   (year(lout'start_est&sfreq)-79+lout'x_cohorts_end,@left.axis.min) to &&
                   (year(lout'start_est&sfreq)-79+lout'x_cohorts_end,@left.axis.max)
         draw line <depict axis bottom, color c14, placement beginning; glue dot> &&
                   (year(lout'start_est&sfreq)-79+lout'x_cohorts_end+lout'reg_cohort_num,@left.axis.min) to &&
                   (year(lout'start_est&sfreq)-79+lout'x_cohorts_end+lout'reg_cohort_num,@left.axis.max)
         draw region <depict axis bottom, color c6,shading paint; glue dot> (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg+1) to 2020
         draw region <depict axis bottom, color c6,shading paint; glue dot> 1850 to (year(lout'start_est&sfreq)-79+lout'x_cohorts_end-1)
      end graph

      cell(2,1)
      graph 
         date * to 1998
         order 4; order region 1,lines 2, markings 3, series 5
         title #1 size med, text "Cohort Effects (Female)"
         title #2 size small, text local'strfreq

         if aveonly
            data lout'ceavgf&sfreq <plot name "Average "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'cef&sfreq <plot name "Raw Cohort Effects", draw line, thickness thick, axis right>
         else
            tick left numeric linear (0 to 1 step 0.2)
            data lout'ceavgf&sfreq <plot name "Average "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'ceminf&sfreq <plot name "Minimum "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'ce25f&sfreq  <plot name "25th Pct Age Effect", draw line>, &&
                 lout'cemedf&sfreq <plot name "Median "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'ce75f&sfreq  <plot name "75th Pct Age Effect", draw line>, &&
                 lout'cemaxf&sfreq <plot name "Maximum "+(if teff then "Time & " else "")+"Age Effect", draw line>, &&
                 lout'cef&sfreq <plot name "Raw Cohort Effects", draw line, thickness thick, axis right>
         end if
         draw line <depict axis bottom, color c14, placement end; glue dot> &&
                   (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg,@left.axis.min) to &&
                   (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg,@left.axis.max)
         draw line <depict axis bottom, color c14, placement end; glue dot> &&
                   (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg-lout'reg_cohort_num,@left.axis.min) to &&
                   (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg-lout'reg_cohort_num,@left.axis.max)
         draw line <depict axis bottom, color c14, placement beginning; glue dot> &&
                   (year(lout'start_est&sfreq)-79+lout'x_cohorts_end,@left.axis.min) to &&
                   (year(lout'start_est&sfreq)-79+lout'x_cohorts_end,@left.axis.max)
         draw line <depict axis bottom, color c14, placement beginning; glue dot> &&
                   (year(lout'start_est&sfreq)-79+lout'x_cohorts_end+lout'reg_cohort_num,@left.axis.min) to &&
                   (year(lout'start_est&sfreq)-79+lout'x_cohorts_end+lout'reg_cohort_num,@left.axis.max)
         draw region <depict axis bottom, color c6,shading paint; glue dot> (year(lout'end_est&sfreq)-16-lout'x_cohorts_beg+1) to 2020
         draw region <depict axis bottom, color c6,shading paint; glue dot> 1850 to (year(lout'start_est&sfreq)-79+lout'x_cohorts_end-1)
      end graph


      close prof.ps
      execute "!(ps2pdf run"+local'runno+"profiles_"+name(sfreq)+".ps; "+ &&
                "gv run"+local'runno+"profiles_"+name(sfreq)+".ps; "+ &&
                "rm -f run"+local'runno+"profiles_"+name(sfreq)+".ps)&"

   end loop


   if local'loutopened
      close lout
   end if

end block
end procedure
